//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2015 BY HOLTEK SEMICONDUCTOR INC
//  File Name : LCD.c
// Description: LCD 
//Targer Board: 
//   MCU      : BH67F2260
//   Author   : ming
//   Date     : 2015/11/23
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#include "common.h"

//pGLݭnΨ gu8a_lcd_buff ݭnNܶqwqbY󤤨ѥ~ϥ
//static volatile __byte_type gu8a_lcd_buff[24]__attribute__ ((at(0x180)));   
__byte_type gu8a_BCD[5];
//void	fun_BIN_TO_BCD(u8 lu8v_dis_mode,u16 lu16v_data);
void	fun_BIN_TO_BCD(u8 lu8v_dis_mode,u16 lu16v_data,u8 lu8v_data_type);
const	u8	display_num[29]= {Display_0,Display_1,Display_2,Display_3,Display_4,Display_5,
Display_6,Display_7,Display_8,Display_9,Display_a,Display_b,Display_c,Display_d,Display_e,
Display_f,Display_all_off,Display_P,Display_L,Display__,Display_r,Display_o,Display_H,
Display_J,Display_U,Display_n,Display_uu,Display_y,Display_t};

/********************************************************************
Function: LCD_ON_OFF
INPUT	:lu8v_lcd_data
OUTPUT	:
NOTE	:ǻѼƥiNҥHram]mP@data
********************************************************************/
void fun_LCD_all(u8 lu8v_lcd_data)
{
     u8 i;
	 for(i=0;i<LU8C_LCD_SEG;i++)	              //G	   
	 {
	    gu8a_lcd_buff[i].u8=lu8v_lcd_data;
	 }
}

/********************************************************************
Function: LCD_INIT
INPUT	:
OUTPUT	:
NOTE	:llcdHsiblcd.ci]m
********************************************************************/
void fun_LCD_INIT()
{
	//IO ?m
	SETLCD_COM4();
	SETLCD_COM5();
	SETLCD_SEG2();
	SETLCD_SEG3();
	SETLCD_SEG4();
	SETLCD_SEG5();
	SETLCD_SEG6();
	SETLCD_SEG7();
	SETLCD_SEG8();
	SETLCD_SEG9();	
	SETLCD_SEG10();
	SETLCD_SEG11();
	SETLCD_SEG12();
	SETLCD_SEG13();	
	SETLCD_SEG14();
	SETLCD_SEG15();
	SETLCD_SEG16();
	SETLCD_SEG17();
	SETLCD_SEG18();		
	SETLCD_SEG19();
	SETLCD_SEG20();
	SETLCD_SEG21();
	SETLCD_SEG22();
	SETLCD_SEG23();
		

	// R OR C	 
	SETLCD_R();
	// LCDi
	SETLCDTYPE_A();
	// LCD qy
	SETRTYPE_200uA();
	// LCDqӷ
	SETLCDPOWER_CPUMP();
	// Charge pumpXq
	SETLCD_CPUMP_3V3();
	// duty
	SETLCDduty_6();
	// bais
	SETLCDbias_3();		
	// ]mLCD}	
	SETLCDPOWER_ON();		

}

/********************************************************************
Function: LCD_Enable
INPUT	:
OUTPUT	:
NOTE	:lcd ϯ
********************************************************************/
void fun_LCD_Enable()
{
	_lcden = 1;
}

/********************************************************************
Function: LCD_Disable
INPUT	:
OUTPUT	:
NOTE	:lcd 
********************************************************************/
void fun_LCD_Disable()
{
	_lcden = 0;
//	_vbgen = 0;
	
}

/********************************************************************
Function: fun_LCD_user
INPUT	:
OUTPUT	:
NOTE	:lcd 
********************************************************************/
void fun_LCD_user(u8 lu8v_mode,u8 lu8v_user_num)
{
	LCD_ICON(LBC_CLR,LCD_User1_ADDR);	
	LCD_ICON(LBC_CLR,LCD_User2_ADDR);	
	LCD_ICON(LBC_CLR,LCD_User3_ADDR);
	LCD_ICON(LBC_CLR,LCD_User4_ADDR);
		
	if(lu8v_user_num == 00)
	{
		LCD_ICON(lu8v_mode,LCD_User1_ADDR);
	}
	else if(lu8v_user_num == 01)
	{
		LCD_ICON(lu8v_mode,LCD_User2_ADDR);
		
	}
	else if(lu8v_user_num == 02)
	{
		LCD_ICON(lu8v_mode,LCD_User3_ADDR);
		
	}
	else if(lu8v_user_num == 03)
	{
		LCD_ICON(lu8v_mode,LCD_User4_ADDR);
		
	}		
}

/********************************************************************
Function: TEST_LCD
INPUT	:
OUTPUT	:
NOTE	:lcdO_`u@IG
********************************************************************/
void TEST_LCD()
{
	u8	i;
	fun_LCD_INIT();
	fun_LCD_all(0x00);	
	fun_LCD_Enable();
	i = 0;
	while(1)
	{
		GCC_CLRWDT();

//		LCD_ICON(LBC_SET,LCD_AM_ADDR);
//		LCD_ICON(LBC_SET,LCD_AVG_ADDR);			
//		LCD_ICON(LBC_SET,LCD_Battery_ADDR);		
//		LCD_ICON(LBC_SET,LCD_COLD_ADDR);				
//		LCD_ICON(LBC_SET,LCD_D_ADDR);
//		LCD_ICON(LBC_SET,LCD_Heart_beep_ADDR);					
//		LCD_ICON(LBC_SET,LCD_heart_ADDR);
////		LCD_ICON(LBC_SET,LCD_Kpa_ADDR);		
//		LCD_ICON(LBC_SET,LCD_M_ADDR);			
//		LCD_ICON(LBC_SET,LCD_No_ADDR);
//		LCD_ICON(LBC_SET,LCD_PM_ADDR);		
//		LCD_ICON(LBC_SET,LCD_User1_ADDR);	
//		LCD_ICON(LBC_SET,LCD_User2_ADDR);												
//		LCD_ICON(LBC_SET,LCD_User3_ADDR);												
//		LCD_ICON(LBC_SET,LCD_User4_ADDR);												
//		LCD_ICON(LBC_SET,LCD_mmhg_ADDR);
//		LCD_DISP_WHO(4);
//		GCC_DELAY(10000);
//		LCD_DISP_DIA_ON(LBC_SET,255);
//		LCD_DISP_SYS_ON(LBC_SET,255);		
//		LCD_DISP_Pluse_ON(LBC_SET,199);		
//		LCD_DISP_MEMORY_ON(LBC_SET,99);	
//		LCD_DISP_MONTH_ON(LBC_SET,12);
//		LCD_DISP_DAY_ON(LBC_SET,20);	
//		LCD_DISP_HOUR_ON(LBC_SET,12);
//		LCD_DISP_MINUTE_ON(LBC_SET,20);	
		i++;
		GCC_DELAY(100000);	
		GCC_DELAY(100000);		
		GCC_DELAY(100000);	
		GCC_DELAY(100000);					
		LCD_DISP_DIA_ON(LBC_SET,i,0);
		LCD_DISP_SYS_ON(LBC_SET,i,0);		
		LCD_DISP_Pluse_ON(LBC_SET,i);		
		LCD_DISP_MEMORY_ON(LBC_SET,i);	
		LCD_DISP_MONTH_ON(LBC_SET,i);
		LCD_DISP_DAY_ON(LBC_SET,i);	
		LCD_DISP_HOUR_ON(LBC_SET,i);
		LCD_DISP_MINUTE_ON(LBC_SET,i);	

	}
}


/********************************************************************
Function: LCD_UPDATA_TIME
INPUT	:
OUTPUT	:
NOTE	: updata time 
********************************************************************/
void LCD_UPDATA_TIME()
{	
//	LCD_DISP_MONTH_ON(LBC_SET,gu8t_time_month);
//	LCD_DISP_DAY_ON(LBC_SET,gu8t_time_day);	
//	LCD_DISP_HOUR_ON(LBC_SET,gu8t_time_hour);
	LCD_DIS_12H_24H(LBC_SET,gu8t_time_hour);
	LCD_DISP_MINUTE_ON(LBC_SET,gu8t_time_minute);	
//	LCD_ICON(LBC_SET,LCD_COLD_ADDR);		
	LCD_ICON(LBC_FLASH,LCD_COL_ADDR);	
//	LCD_ICON(LBC_SET,LCD_D_ADDR);
//	LCD_ICON(LBC_SET,LCD_M_ADDR);
			
	
}

/********************************************************************
Function: LCD_UPDATA_TIME
INPUT	:
OUTPUT	:
NOTE	: updata time 
********************************************************************/
void LCD_DIS_12H_24H(u8	lu8v_mode,u8	lu8v_hour)
{
	if(gbv_12h_24h)
	{
		if(lu8v_hour>12)
		{
			LCD_DISP_HOUR_ON(lu8v_mode,lu8v_hour-12);
			LCD_ICON(LBC_SET,LCD_PM_ADDR);
			LCD_ICON(LBC_CLR,LCD_AM_ADDR);							
		}
		else if(lu8v_hour ==12)
		{
			LCD_DISP_HOUR_ON(lu8v_mode,lu8v_hour);
			LCD_ICON(LBC_SET,LCD_PM_ADDR);
			LCD_ICON(LBC_CLR,LCD_AM_ADDR);			
		}		
		else if(lu8v_hour ==0)
		{
			LCD_DISP_HOUR_ON(lu8v_mode,12);
			LCD_ICON(LBC_CLR,LCD_PM_ADDR);
			LCD_ICON(LBC_SET,LCD_AM_ADDR);							
		}
		else
		{
			LCD_DISP_HOUR_ON(lu8v_mode,lu8v_hour);
			LCD_ICON(LBC_CLR,LCD_PM_ADDR);
			LCD_ICON(LBC_SET,LCD_AM_ADDR);				
		}
		
	}
	else
	{
		LCD_DISP_HOUR_ON(lu8v_mode,lu8v_hour);	
		LCD_ICON(LBC_CLR,LCD_PM_ADDR);
		LCD_ICON(LBC_CLR,LCD_AM_ADDR);				
	}
	
}
/********************************************************************
Function: LCD_UPDATA_TIME
INPUT	:
OUTPUT	:
NOTE	: updata time 
********************************************************************/
void LCD_UPDATA_ERR(u8	lu8v_err_code)
{	
	gu8a_BCD[2].u8 = display_num[0X10];
	gu8a_BCD[1].u8 = Display_E;
	gu8a_BCD[0].u8 = display_num[lu8v_err_code];
}


/********************************************************************
Function: LCD_UPDATA_TIME
INPUT	:
OUTPUT	:
NOTE	: updata time 
********************************************************************/
void LCD_UPDATA_vol()
{	
	gu8a_BCD[2].u8 = Display_U;
	gu8a_BCD[1].u8 = Display_o;
	gu8a_BCD[0].u8 = Display_L;
}


/********************************************************************
Function: LCD_ICON
INPUT	:gu8v_lcd_disp_mode gu8v_lcd_addr gu8v_lcd_no
OUTPUT	:
NOTE	:
		gu8v_lcd_disp_mode = LBC_CLR/LBC_SET/LBC_250MS_TIGGER/LBC_500MS_TIGGER
		gu8v_lcd_addr = ICON ADDR
		gu8v_lcd_no   = BIT m
		i{IܥHΰ{{Aݭnmɶлxgbv_250ms_tigger||gbv_500ms_tigger
********************************************************************/
void LCD_ICON(u8 gu8v_lcd_disp_mode, u8 gu8v_lcd_addr,u8 gu8v_lcd_no)
{	
	if(gu8v_lcd_disp_mode == 0)      
	{
 		gu8a_lcd_buff[gu8v_lcd_addr].u8 &= ~gu8v_lcd_no; 
	}
	else if(gu8v_lcd_disp_mode == 1) 
	{
		gu8a_lcd_buff[gu8v_lcd_addr].u8 |= gu8v_lcd_no;  	
	}
	else if(gu8v_lcd_disp_mode == 2)  
	{
		if(gbv_500ms_tigger)	
		{
			gu8a_lcd_buff[gu8v_lcd_addr].u8 |= gu8v_lcd_no;  	
		}
        else
		{
 			gu8a_lcd_buff[gu8v_lcd_addr].u8 &= ~gu8v_lcd_no; 
		} 
	}
	else if(gu8v_lcd_disp_mode == 3)  
	{
		if(gbv_250ms_tigger)	
		{
			gu8a_lcd_buff[gu8v_lcd_addr].u8 |= gu8v_lcd_no;  	
		}
        else
		{
 			gu8a_lcd_buff[gu8v_lcd_addr].u8 &= ~gu8v_lcd_no; 
		} 
	}	
}

//;;******************************************************************************************
//;; ?W?: SBR_DISP_DOT_WX
//;; ?yz: T1~T6 1isT1 2isT1T2 3isT1T2T3......
//;; ?J??: lu8v_w_level 0 - 5 
//;; ?X??: ? 
//;;******************************************************************************************
void	LCD_DISP_WHO(u8 lu8v_w_level)
{
	u8 i ;
	volatile	__16_type	lu8v_DOT_WX_BUFF;
	if(lu8v_w_level>5)
	{
		lu8v_w_level = 5;
	}
	lu8v_DOT_WX_BUFF.u16 = 1;
	for	(i = 0; i<lu8v_w_level;i++)
	{
		lu8v_DOT_WX_BUFF.u16 = lu8v_DOT_WX_BUFF.u16*2+1;
	}

	//MWHO1-WHO6 
	gu8a_lcd_buff[0].u8 = 0;	
	gu8a_lcd_buff[1].bits.b0 = 0;	



	if(lu8v_DOT_WX_BUFF.bits.b0)
	{
		gu8a_lcd_buff[1].bits.b0 = 1;	
	}
	if(lu8v_DOT_WX_BUFF.bits.b1)
	{
		gu8a_lcd_buff[0].bits.b3 = 1;	
	}
	if(lu8v_DOT_WX_BUFF.bits.b2)
	{
		gu8a_lcd_buff[0].bits.b2 = 1;
	}
	if(lu8v_DOT_WX_BUFF.bits.b3)
	{
		gu8a_lcd_buff[0].bits.b1 = 1;	
	}	
	if(lu8v_DOT_WX_BUFF.bits.b4)
	{
		gu8a_lcd_buff[0].bits.b0 = 1;	
	}
	if(lu8v_DOT_WX_BUFF.bits.b5)
	{
		gu8a_lcd_buff[21].bits.b0 = 1;		
	}	
	
}
/********************************************************************
Function: LCD_DISP_UNIT
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_UNIT(u8	lu8v_mode)
{
	if(lu8v_mode)
	{
		LCD_ICON(LBC_SET,LCD_Kpa_ADDR);				
		LCD_ICON(LBC_CLR,LCD_mmhg_ADDR);		
	}
	else
	{
		LCD_ICON(LBC_SET,LCD_mmhg_ADDR);					
		LCD_ICON(LBC_CLR,LCD_Kpa_ADDR);					
	}	
}


/********************************************************************
Function: LCD_DISP_Surface_or_Body
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_KP_or_MMHG(u8	lu8v_mode,u16	lu16v_sys,u16	lu16v_dia)
{
	if(lu8v_mode)
	{
		//kp				
		LCD_DISP_DIA_ON(LBC_SET,lu16v_dia*100/75,1);
		LCD_DISP_SYS_ON(LBC_SET,lu16v_sys*100/75,1);			
		LCD_ICON(LBC_SET,LCD_POINT1_ADDR);
		LCD_ICON(LBC_SET,LCD_POINT2_ADDR);		
	}
	else
	{
		//mmhg
		LCD_DISP_DIA_ON(LBC_SET,lu16v_dia,0);
		LCD_DISP_SYS_ON(LBC_SET,lu16v_sys,0);	
		LCD_ICON(LBC_CLR,LCD_POINT1_ADDR);
		LCD_ICON(LBC_CLR,LCD_POINT2_ADDR);			
	}
}


/********************************************************************
Function: LCD_DISP_DIA
INPUT	:
OUTPUT	:
NOTE	:ܵαihX
********************************************************************/
void	LCD_DISP_DIA()
{
	_mp1h = 4;
	_mp1l = 3;	
	
	SFR_iar1.u8 &= 0b11110000;	
	if(gu8a_BCD[2].bits.SEG_C)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[2].bits.SEG_B)
	{
		SFR_iar1.bits.b1 = 1;		
	}	
	if(gu8a_BCD[2].bits.SEG_A)
	{
		SFR_iar1.bits.b2 = 1;		
	}	
	if(gu8a_BCD[2].bits.SEG_G)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	if(gu8a_BCD[2].bits.SEG_D)
	{
		SFR_iar1.bits.b2 = 1;		
	}		
	if(gu8a_BCD[2].bits.SEG_E)
	{
		SFR_iar1.bits.b3 = 1;		
	}		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111100;	
	if(gu8a_BCD[1].bits.SEG_F)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_E)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	
		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111000;	
	if(gu8a_BCD[1].bits.SEG_A)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_G)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_D)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111001;	

	if(gu8a_BCD[1].bits.SEG_B)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_C)
	{
		SFR_iar1.bits.b2 = 1;		
	}	

	
	_mp1l ++;	
	SFR_iar1.u8 &= 0b11111001;	
	if(gu8a_BCD[0].bits.SEG_F)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_E)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	
		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111000;	
	if(gu8a_BCD[0].bits.SEG_A)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_G)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_D)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111001;	

	if(gu8a_BCD[0].bits.SEG_B)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_C)
	{
		SFR_iar1.bits.b2 = 1;		
	}	
	
		
	
}

/********************************************************************
Function: LCD_DISP_Hypotension_ON
INPUT	:
OUTPUT	:
NOTE	:CܥiqLեΦƹ{C
********************************************************************/
void	LCD_DISP_DIA_ON(u8 lu8v_dis_mode,u16 lu16c_Hypotension,volatile	u8	lu8v_type)
{
	fun_BIN_TO_BCD(lu8v_dis_mode,lu16c_Hypotension,lu8v_type);
	LCD_DISP_DIA();	
}

/********************************************************************
Function: LCD_DISP_SYS
INPUT	:
OUTPUT	:
NOTE	:ܩhX
********************************************************************/
void	LCD_DISP_SYS()
{
	
	_mp1h = 4;
	_mp1l = 10;	
	
	SFR_iar1.u8 &= 0b11000011;	
	if(gu8a_BCD[2].bits.SEG_C)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	if(gu8a_BCD[2].bits.SEG_B)
	{
		SFR_iar1.bits.b3 = 1;		
	}	
	if(gu8a_BCD[2].bits.SEG_A)
	{
		SFR_iar1.bits.b4 = 1;		
	}	
	if(gu8a_BCD[2].bits.SEG_G)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[2].bits.SEG_D)
	{
		SFR_iar1.bits.b4 = 1;		
	}		
	if(gu8a_BCD[2].bits.SEG_E)
	{
		SFR_iar1.bits.b5 = 1;		
	}		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11100111;	
	if(gu8a_BCD[1].bits.SEG_F)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_E)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	
		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11000111;	
	if(gu8a_BCD[1].bits.SEG_A)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_G)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_D)
	{
		SFR_iar1.bits.b5 = 1;		
	}
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11100111;	

	if(gu8a_BCD[1].bits.SEG_B)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_C)
	{
		SFR_iar1.bits.b4 = 1;		
	}	

	
	_mp1l ++;	
	SFR_iar1.u8 &= 0b11100111;	
	if(gu8a_BCD[0].bits.SEG_F)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_E)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	
		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11000111;	
	if(gu8a_BCD[0].bits.SEG_A)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_G)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_D)
	{
		SFR_iar1.bits.b5 = 1;		
	}
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11100111;	

	if(gu8a_BCD[0].bits.SEG_B)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_C)
	{
		SFR_iar1.bits.b4 = 1;		
	}	
	
}

/********************************************************************
Function: LCD_DISP_SYS_ON
INPUT	:
OUTPUT	:
NOTE	:YܥiqLեΦƹ{C
********************************************************************/
void	LCD_DISP_SYS_ON(u8 lu8v_dis_mode,u16 lu16c_Hypotension,u8	lu8v_type)
{
	fun_BIN_TO_BCD(lu8v_dis_mode,lu16c_Hypotension,lu8v_type);
	LCD_DISP_SYS();	
}

/********************************************************************
Function: LCD_DISP_Pluse
INPUT	:
OUTPUT	:
NOTE	:ܤ߸Xʩh
********************************************************************/
void	LCD_DISP_Pluse()
{
	_mp1h = 4;
	_mp1l = 4;	
	
	SFR_iar1.u8 &= 0b11000111;	
	if(gu8a_BCD[2].bits.SEG_B)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[2].bits.SEG_C)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	
	if(gu8a_BCD[1].bits.SEG_F)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_E)
	{
		SFR_iar1.bits.b5 = 1;		
	}
	
		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11000111;	
	if(gu8a_BCD[1].bits.SEG_A)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_G)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_D)
	{
		SFR_iar1.bits.b5 = 1;		
	}
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11001111;	

	if(gu8a_BCD[1].bits.SEG_B)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_C)
	{
		SFR_iar1.bits.b5 = 1;		
	}	
	
	
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11001111;	
	if(gu8a_BCD[0].bits.SEG_F)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_E)
	{
		SFR_iar1.bits.b5 = 1;		
	}
	
		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11000111;	
	if(gu8a_BCD[0].bits.SEG_A)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_G)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_D)
	{
		SFR_iar1.bits.b5 = 1;		
	}
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11001111;	

	if(gu8a_BCD[0].bits.SEG_B)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_C)
	{
		SFR_iar1.bits.b5 = 1;		
	}

}
/********************************************************************
Function: LCD_DISP_Pluse
INPUT	:
OUTPUT	:
NOTE	:ܤ߸
********************************************************************/
void	LCD_DISP_Pluse_ON(u8 lu8v_dis_mode,u16 lu16c_Hypotension)
{
	fun_BIN_TO_BCD(lu8v_dis_mode,lu16c_Hypotension,0);
	LCD_DISP_Pluse();	
}

/********************************************************************
Function: LCD_DISP_MEMORY
INPUT	:
OUTPUT	:
NOTE	:OвռXʩh
********************************************************************/
void	LCD_DISP_MEMORY()
{
	_mp1h = 4;
	_mp1l = 10;	
	
	SFR_iar1.u8 &= 0b11111101;	
	if(gu8a_BCD[2].bits.SEG_C)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[2].bits.SEG_B)
	{
		SFR_iar1.bits.b1 = 1;		
	}	
	
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111001;	
	if(gu8a_BCD[1].bits.SEG_F)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_E)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	
		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111000;	
	if(gu8a_BCD[1].bits.SEG_A)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_G)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_D)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111001;	

	if(gu8a_BCD[1].bits.SEG_B)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_C)
	{
		SFR_iar1.bits.b2 = 1;		
	}	

	
	_mp1l ++;	
	SFR_iar1.u8 &= 0b11111001;	
	if(gu8a_BCD[0].bits.SEG_F)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_E)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	
		
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111000;	
	if(gu8a_BCD[0].bits.SEG_A)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_G)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_D)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	_mp1l ++;	
	
	SFR_iar1.u8 &= 0b11111001;	

	if(gu8a_BCD[0].bits.SEG_B)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_C)
	{
		SFR_iar1.bits.b2 = 1;		
	}	
}

/********************************************************************
Function: LCD_DISP_MEMORY_ON
INPUT	:
OUTPUT	:
NOTE	:Oвռ
********************************************************************/
void	LCD_DISP_MEMORY_ON(u8 lu8v_dis_mode,u16 lu16c_Hypotension)
{
	fun_BIN_TO_BCD(lu8v_dis_mode,lu16c_Hypotension,0);
	LCD_DISP_MEMORY();		
}

/********************************************************************
Function: LCD_DISP_MONTH
INPUT	:
OUTPUT	:
NOTE	:Xʩh
********************************************************************/
void	LCD_DISP_MONTH()
{
	_mp1h = 4;
	_mp1l = 17;	
	
	SFR_iar1.u8 &= 0b11000011;	
	if(gu8a_BCD[1].bits.SEG_C)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_B)
	{
		SFR_iar1.bits.b3 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_A)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_G)
	{
		SFR_iar1.bits.b4 = 1;		
	}		
	if(gu8a_BCD[1].bits.SEG_D)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_E)
	{
		SFR_iar1.bits.b5 = 1;		
	}	
			
	_mp1l ++;	
	SFR_iar1.u8 &= 0b11011111;	
	if(gu8a_BCD[0].bits.SEG_D)
	{
		SFR_iar1.bits.b5 = 1;		
	}	
	
	_mp1l = 23;	
	SFR_iar1.u8 &= 0b11000000;	
	if(gu8a_BCD[0].bits.SEG_A)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_F)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_B)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_G)
	{
		SFR_iar1.bits.b3 = 1;		
	}		
	if(gu8a_BCD[0].bits.SEG_E)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_C)
	{
		SFR_iar1.bits.b5 = 1;		
	}		

}
/********************************************************************
Function: LCD_DISP_MONTH_ON
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_MONTH_ON(u8 lu8v_dis_mode,u16 lu16c_Hypotension)
{
	fun_BIN_TO_BCD(lu8v_dis_mode,lu16c_Hypotension,0);
	LCD_DISP_MONTH();	
}


/********************************************************************
Function: LCD_DISP_DAY
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_DAY()
{
	_mp1h = 4;
	_mp1l = 22;	
	SFR_iar1.u8 &= 0b11000000;	
	if(gu8a_BCD[1].bits.SEG_A)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_F)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_B)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_G)
	{
		SFR_iar1.bits.b3 = 1;		
	}		
	if(gu8a_BCD[1].bits.SEG_E)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[1].bits.SEG_C)
	{
		SFR_iar1.bits.b5 = 1;		
	}	
	_mp1l = 21;	
	SFR_iar1.u8 &= 0b11000000;	
	if(gu8a_BCD[0].bits.SEG_A)
	{
		SFR_iar1.bits.b0 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_F)
	{
		SFR_iar1.bits.b1 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_B)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_G)
	{
		SFR_iar1.bits.b3 = 1;		
	}		
	if(gu8a_BCD[0].bits.SEG_E)
	{
		SFR_iar1.bits.b4 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_C)
	{
		SFR_iar1.bits.b5 = 1;		
	}
	_mp1l = 18;	
	SFR_iar1.u8 &= 0b11110011;	
	if(gu8a_BCD[1].bits.SEG_D)
	{
		SFR_iar1.bits.b2 = 1;		
	}
	if(gu8a_BCD[0].bits.SEG_D)
	{
		SFR_iar1.bits.b3 = 1;		
	}			
}

/********************************************************************
Function: LCD_DISP_DAY_ON
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_DAY_ON(u8 lu8v_dis_mode,u16 lu16c_Hypotension)
{
	fun_BIN_TO_BCD(lu8v_dis_mode,lu16c_Hypotension,0);
//	if(gu8a_BCD[1].u8 == display_num[0x10])
//	{
//		gu8a_BCD[1].u8 = display_num[0];
//	}
	
	LCD_DISP_DAY();	

}

/********************************************************************
Function: LCD_DISP_HOUR
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_HOUR()
{
	

}
/********************************************************************
Function: LCD_DISP_HOUR_ON
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_HOUR_ON(u8 lu8v_dis_mode,u16 lu16c_Hypotension)
{

	
	fun_BIN_TO_BCD(lu8v_dis_mode,lu16c_Hypotension,0);
	LCD_DISP_MONTH();	
}

/********************************************************************
Function: LCD_DISP_MINUTE
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_MINUTE()
{

	
}

/********************************************************************
Function: LCD_DISP_MINUTE_ON
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void	LCD_DISP_MINUTE_ON(u8 lu8v_dis_mode,u16 lu16c_Hypotension)
{
	fun_BIN_TO_BCD(lu8v_dis_mode,lu16c_Hypotension,0);
//	if(gu8a_BCD[1].u8 == display_num[0x10]&&gu8a_BCD[0].u8 != display_num[0x10])
//	{
//		gu8a_BCD[1].u8 = display_num[0];
//	}	
	LCD_DISP_DAY();	
}

/********************************************************************
Function: LCD_DISP_LETTER_ON
INPUT	:
OUTPUT	:
NOTE	:ܦr
********************************************************************/
void	LCD_DISP_LETTER_ON(u8 lu8v_dis_mode,u8 lu8c_local,u8 lu8c_letter2,u8 lu8c_letter1,u8 lu8c_letter0)
{
	gu8a_BCD[0].u8 = lu8c_letter0;
	gu8a_BCD[1].u8 = lu8c_letter1;	
	gu8a_BCD[2].u8 = lu8c_letter2;		
	fun_BIN_TO_BCD(lu8v_dis_mode,0,3);
	if(lu8c_local == 0)
	{
		LCD_DISP_DIA();	
	}
	else if(lu8c_local == 1)
	{
		LCD_DISP_SYS();		
	}
	else if(lu8c_local == 2)
	{
		LCD_DISP_Pluse();		
	}	
}

////;****************************************************************
////;16bit binary to BCD
////;input:_gu8a_BCD[D]ataL(LSB),_gu8a_BCD[D]ataH(MSB)
////;output:_gu8a_BCD[0](?),_gu8a_BCD[1](Q),_gu8a_BCD[2](ʦ),_gu8a_BCD[3](d),_gu8a_BCD[4](E)
////;effect:_gu8a_BCD[5]
////;****************************************************************
//void	fun_BIN_TO_BCD(u8 lu8v_dis_mode,u16 lu16v_data)
//{
//	u8	i;
//
//
//	if(lu8v_dis_mode & LBC_HID)
//	{
//		//ƥ~gu8a_BCD[0]gu8a_BCD[1]gu8a_BCD[2]
//	}
//	else
//	{
//		for(i=0;i<5;i++)
//		{	
//			gu8a_BCD[i].u8 = lu16v_data%10;
//			lu16v_data = lu16v_data/10;		
//		}
//		if(gu8a_BCD[2].u8 >= 4)
//		{
//			gu8a_BCD[2].u8 = 0;
//		}
//		if(gu8a_BCD[2].u8 == 0)
//		{
//			gu8a_BCD[2].u8 = 0x10;
//			if(gu8a_BCD[1].u8== 0)
//			{
//				gu8a_BCD[1].u8 = 0x10;
//			}
//		}
//		gu8a_BCD[0].u8 = display_num[gu8a_BCD[0].u8];
//		gu8a_BCD[1].u8 = display_num[gu8a_BCD[1].u8];
//		gu8a_BCD[2].u8 = display_num[gu8a_BCD[2].u8];
//	}
//	
////	lu8v_dis_mode &= ~LBC_HID;
//
//	if(lu8v_dis_mode == LBC_CLR)
//	{
//		gu8a_BCD[0].u8 = display_num[0x10];
//		gu8a_BCD[1].u8 = display_num[0x10];
//		gu8a_BCD[2].u8 = display_num[0x10];
//	}
//	else if(lu8v_dis_mode == LBC_SET)
//	{
//	}
//	else if(lu8v_dis_mode == LBC_FLASH)
//	{
//		if(gbv_500ms_tigger)
//		{
//		}
//		else
//		{
//			gu8a_BCD[0].u8 = display_num[0x10];
//			gu8a_BCD[1].u8 = display_num[0x10];
//			gu8a_BCD[2].u8 = display_num[0x10];		
//		}
//	}
//	else if(lu8v_dis_mode == LBC_FFLASH)
//	{
//		if(gbv_250ms_tigger)
//		{
//
//		}
//		else
//		{
//			gu8a_BCD[0].u8 = display_num[0x10];
//			gu8a_BCD[1].u8 = display_num[0x10];
//			gu8a_BCD[2].u8 = display_num[0x10];		
//		}
//	}
//}

//;****************************************************************
//;16bit binary to BCD
//;input:_gu8a_BCD[D]ataL(LSB),_gu8a_BCD[D]ataH(MSB)
//;output:_gu8a_BCD[0](?),_gu8a_BCD[1](Q),_gu8a_BCD[2](ʦ),_gu8a_BCD[3](d),_gu8a_BCD[4](E)
//;effect:_gu8a_BCD[5]  ROM 150word
//;****************************************************************
void	fun_BIN_TO_BCD(u8 lu8v_dis_mode,u16 lu16v_data,u8 lu8v_data_type)
{
	u8	i;
	if(lu8v_dis_mode & LBC_HID)
	{
		//ƥ~gu8a_BCD[0]gu8a_BCD[1]gu8a_BCD[2]
	}
	else
	{
		for(i=0;i<5;i++)
		{	
			gu8a_BCD[i].u8 = lu16v_data%10;
			lu16v_data = lu16v_data/10;		
		}

		if(gu8a_BCD[3].u8 == 0)
		{	
			if(lu8v_data_type<3)
			{							
				gu8a_BCD[3].u8 = 0x10;
			}
			if(gu8a_BCD[2].u8 == 0)
			{
				if(lu8v_data_type<2)
				{
					gu8a_BCD[2].u8 = 0x10;
				}
				if(gu8a_BCD[1].u8== 0)
				{
					if(lu8v_data_type<1)
					{
						gu8a_BCD[1].u8 = 0x10;							
					}
				}
			}
		}
		gu8a_BCD[0].u8 = display_num[gu8a_BCD[0].u8];
		gu8a_BCD[1].u8 = display_num[gu8a_BCD[1].u8];
		gu8a_BCD[2].u8 = display_num[gu8a_BCD[2].u8];
		gu8a_BCD[3].u8 = display_num[gu8a_BCD[3].u8];		
	}
	
//	lu8v_dis_mode &= ~LBC_HID;

	if(lu8v_dis_mode == LBC_CLR)
	{
		gu8a_BCD[0].u8 = display_num[0x10];
		gu8a_BCD[1].u8 = display_num[0x10];
		gu8a_BCD[2].u8 = display_num[0x10];
		gu8a_BCD[3].u8 = display_num[0x10];
		
	}
	else if(lu8v_dis_mode == LBC_SET)
	{
	}
	else if(lu8v_dis_mode == LBC_FLASH)
	{
		if(gbv_500ms_tigger)
		{
		}
		else
		{
			gu8a_BCD[0].u8 = display_num[0x10];
			gu8a_BCD[1].u8 = display_num[0x10];
			gu8a_BCD[2].u8 = display_num[0x10];
			gu8a_BCD[3].u8 = display_num[0x10];	
		}
	}
	else if(lu8v_dis_mode == LBC_FFLASH)
	{
		if(gbv_250ms_tigger)
		{

		}
		else
		{
			gu8a_BCD[0].u8 = display_num[0x10];
			gu8a_BCD[1].u8 = display_num[0x10];
			gu8a_BCD[2].u8 = display_num[0x10];
			gu8a_BCD[3].u8 = display_num[0x10];	
		}
	}
}
